IF EXISTS (SELECT * FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_EST_PED_VD_FATURAMENTO_AUTOMATICO]'))
DROP VIEW [dbo].[V_EST_PED_VD_FATURAMENTO_AUTOMATICO]
GO

CREATE  VIEW [dbo].[V_EST_PED_VD_FATURAMENTO_AUTOMATICO]

AS
    WITH NFE_REFERENCIADA
        AS (SELECT ROW_NUMBER() OVER(PARTITION BY NFE_REF.CD_EMP
                                                  , NFE_REF.CD_FILIAL
                                                  , NFE_REF.CD_PED ORDER BY NFE_REF.CD_EMP
                                                                          , NFE_REF.CD_FILIAL
                                                                          , NFE_REF.CD_PED) AS ID_ROW
                   , NFE_REF.*
                   , PNFENT.CD_NF
              FROM
                   EST_PED_VD PED
                   INNER JOIN EST_PED_VD_PENDENCIA PEND
                   ON PED.CD_EMP = PEND.CD_EMP
                      AND PED.CD_FILIAL = PEND.CD_FILIAL
                      AND PED.CD_PED = PEND.CD_PED
                   INNER JOIN EST_NF_ENT_EST_PED_VD PNFENT
                   ON PED.CD_EMP = PNFENT.CD_EMP
                      AND PED.CD_FILIAL = PNFENT.CD_FILIAL
                      AND PED.CD_PED = PNFENT.CD_PED
                   INNER JOIN EST_PED_VD_DEVOLUCAO_NFE_CHAVE_REFERENCIA NFE_REF
                   ON PED.CD_EMP = NFE_REF.CD_EMP
                      AND PED.CD_FILIAL = NFE_REF.CD_FILIAL
                      AND PED.CD_PED = NFE_REF.CD_PED)
          SELECT PED.CD_EMP
               , PED.CD_FILIAL
               , 0 AS CD_NF
               , PED.CD_PED
               , PED.CD_CLI
               , CONVERT( CHAR(10), DBO.GETDATE_FUSO_HORARIO(PED.CD_FILIAL), 112) AS DT_EMI_NF
               , 0 AS NF_NF
               , ISNULL(
                       (
                           SELECT TOP 1 CD_NF_SERIE
                           FROM PRC_FILIAL_NF_SERIES FISERIE
                           WHERE PED.CD_EMP = FISERIE.CD_EMP
                                 AND PED.CD_FILIAL = FISERIE.CD_FILIAL
                                 AND FISERIE.NF_SERIE_PD = 1
                       ), 0) AS CD_NF_SERIE
               , 0 AS VLR_NF_CAB
               , 0 AS VLR_ICMS_CAB
               , ISNULL(PED.VLR_FRETE, 0) AS VLR_FRETE_CAB
               , 0 AS VLR_OUTROS_CAB
               , 0 AS VLR_BASE_ICMS_CAB
               , 0 AS ALIQ_ICMS_CAB
               , 0 AS VLR_TOT_PROD_CAB
               , PED.CD_NT_MOV
               , 0 AS VLR_DESC_CAB
               , 0 AS VLR_BASE_ICMS_SUBS
               , 0 AS VLR_ICMS_SUBS_CAB
               , 0 AS VLR_IPI_CAB
               , CONVERT( CHAR(10), GETDATE(), 112) AS DT_CAD
               , 0 AS DEV
               , ISNULL(PED.CD_VEND, 0) AS CD_VEND
               , PED.CD_COND_PGTO
               , 0 AS COB
               , 0 AS STS_NF
               , 0 AS TP_NF
               , ISNULL(LEFT(PED.OBS, 150), '') AS OBS1
               , ISNULL(LEFT(PED.OBS_NF1, 150), '') AS OBS2
               , ISNULL(LEFT(PED.OBS_NF2, 150), '') AS OBS3
               , ISNULL(LEFT(PED.OBS_NF4, 150), '') AS OBS4
               , ISNULL(LEFT(PED.OBS_NF5, 150), '') AS OBS5
               , ISNULL(LEFT(PED.OBS_NF6, 150), '') AS OBS6
               , ISNULL(LEFT(PED.OBS_NF7, 150), '') AS OBS7
               , ISNULL(LEFT(PED.OBS_NF8, 150), '') AS OBS8
               , ISNULL(LEFT(PED.OBS_NF9, 150), '') AS OBS9
               , ISNULL(LEFT(PED.OBS_NF10, 150), '') AS OBS10
               , ISNULL(LEFT(PED.OBS_NF11, 150), '') AS OBS11
               , ISNULL(CD_TRANSP, 0) AS CD_TRANSP
               , ISNULL(PED.QT_VOL, 0) AS QT_VOL
               , ISNULL(PED.ESP_VOL, '') AS ESP_VOL
               , ISNULL(PED.MC_VOL, '') AS MC_VOL
               , ISNULL(PED.NR_VOL, 0) AS NR_VOL
               , ISNULL(PED.PESO_VOL, 0) AS PESO_VOL
               , ISNULL(PED.PESO_LIQ_VOL, 0) AS PESO_LIQ_VOL
               , ISNULL(PED.EMAIL_TRANSP, '') AS EMAIL_TRANSP
               , ISNULL(PED.FRETE, 0) TP_FRETE
        , 0 AS TP_DEV_NF
               , NULL AS DT_CANCEL
               , 0 AS VLR_ISENTAS_CAB
               , 0 AS VLR_OUTRAS_CAB
               , ISNULL(NFE_REFERENCIADA.CD_NF, 0) AS CD_NF_ENT
               , ISNULL(PNFSAI.CD_NF, 0) AS CD_NF_SAI
               , ISNULL(PCONF.CD_USU, PED.CD_USU) AS CD_USU
               , 0 AS VLR_PROD_ICMS_SUBS_CAB
               , NULL AS DT_ULT_ALT
               , 0 AS LANC_EFETU
               , '' AS NM_COMPRADOR
               , 0 AS VLR_BASE_ICMS_IT_CAB
               , 0 AS NF_PROD_SERV
               , CONVERT( CHAR(10), DBO.GETDATE_FUSO_HORARIO(PED.CD_FILIAL), 108) AS HR_EMI_NF
               , 0 AS VLR_DESC_CORPO
               , '' AS INF_DESCONTO
               , ISNULL(NM_TRANSP, '') AS DS_TRANSP
               , ISNULL(PLACA_VEIC, '') AS PLACA_VEIC
               , ISNULL(PLACA_UF, '') AS PLACA_UF
               , ISNULL(CGC_CPF_TRANSP, '') AS CGC_CPF_TRANSP
               , ISNULL(ENDE_TRANSP, '') AS ENDE_TRANSP
               , ISNULL(DS_CID_TRANSP, '') AS DS_CID_TRANSF
               , ISNULL(UF_TRANSP, '') AS UF_TRANSP
               , ISNULL(INSC_EST_TRANSP, '') AS INSC_EST_TRANSP
               , 0 AS VLR_ISSQN_CAB
               , 0 AS VLR_SERVICO_CAB
               , 0 AS PERC_ISSQN_CAB
               , 0 AS VLR_SULFRAMA_CAB
               , 0 AS PEND_ENTRADA
               , 0 AS NR_SELO_SAIDA
               , 0 AS CD_MT_CANCEL
               , 0 AS NR_FORMULARIO
               , 0 AS CD_MOT_EMIS_NF
               , 0 AS QT_CX_VOL
               , 0 AS R_E_C_N_O_
               , 1 AS FLAG_NF_PROD_TOTAL_BRUTO
               , 0 AS FLAG_IGNORAR_CONTROL
               , 0 AS VLR_BASE_ICMS_RET_CAB
               , 0 AS VLR_ICMS_RET_CAB
               , 0 AS NF_MANUAL
               , ISNULL(PED.BAIRRO_DESTINATARIO, '') AS BAIRRO_DESTINATARIO
               , '' AS BAIRRO_EMITENTE
               , ISNULL(PED.CEP_DESTINATARIO, '') AS CEP_DESTINATARIO
               , '' AS CEP_EMITENTE
               , ISNULL(PED.CIDADE_DESTINATARIO, '') AS CIDADE_DESTINATARIO
               , '' AS CIDADE_EMITENTE
               , '' AS CNPJ_DESTINATARIO
               , '' AS CNPJ_EMITENTE
               , ISNULL(PED.END_DESTINATARIO, '') AS END_DESTINATARIO
               , '' AS END_EMITENTE
               , '' AS INSC_ESTADUAL_DESTINATARIO
               , '' AS INSC_ESTADUAL_EMITENTE
               , '' AS NT_OPERACAO
               , '' AS RZ_DESTINATARIO
               , '' AS RZ_EMITENTE
               , '' AS RZ_TRANSPORTADOR
               , ISNULL(PED.UF_DESTINATARIO, '') AS UF_DESTINATARIO
               , '' AS UF_EMITENTE
               , '' AS APLICATIVO
               , '' AS VERSAO_APLICATIVO
               , 0 AS CD_CID_TRANSP
               , 0 AS CD_CID_EMITENTE
               , ISNULL(PED.CD_CID_DESTINATARIO, 0) AS CD_CID_DESTINATARIO
               , 0 AS CD_NT_OP_TRANSF_ENTRADA
               , 0 AS FLAG_NOTA_INTEGRACAO
               , '' AS XML_NOTA
               , '' AS XPED_NOTA_FISCAL
               , 0 AS NFE_REJEITADA
			   , ISNULL(PED.FLAG_FRETE_BASE_ICMS, 0) AS FLAG_FRETE_BASE_ICMS
               , PEDIT.CD_PROD
               , LEFT(EST_PROD.DS_PROD, 50) AS DS_PROD
               , PEDIT.VLR_IT
			   , CAST(PEDIT.QT_IT AS MONEY) AS QT_IT
               , ISNULL(PEDIT.VLR_ICMS_IT, 0) AS VLR_ICMS_IT
               , ISNULL(PEDIT.ALIQ_ICMS, 0) AS ALIQ_ICMS_IT
               , PEDIT.CD_TRIB
               , UN.DS_UN
               , UN.TP_UN
               , PEDIT.PERC_IPI
               , CASE
                     WHEN ISNULL(PEDIT.VLR_CUSTO, 0) > 0
                     THEN ISNULL(PEDIT.VLR_CUSTO, 0)
                     ELSE ISNULL(EST_PROD_CPL.VLR_CUSTO, 0)
                 END AS VLR_CUSTO
               , ISNULL(PEDIT.VLR_BASE_ICMS_SUBS, 0) AS VLR_BASE_SUBS_IT
               , ISNULL(PEDIT.VLR_ICMS_SUBS, 0) AS VLR_ICMS_SUBS_IT
               , CASE
                 WHEN GLB_MOV_OP.TP_ESTQ = 0
                     THEN EST_PROD_CPL.QT_EST
                     WHEN GLB_MOV_OP.TP_ESTQ = 1
                     THEN EST_PROD_CPL.QT_EST_FLUT
                     WHEN GLB_MOV_OP.TP_ESTQ = 2
                     THEN EST_PROD_CPL.QT_EST_EM_TERC
                     WHEN GLB_MOV_OP.TP_ESTQ = 3
                     THEN EST_PROD_CPL.QT_EST_DE_TERC
                     ELSE 0
                 END AS QT_EST_ANT
               , 0 AS CD_NT_OP
               , ISNULL(PEDIT.VLR_BASE_ICMS_IT, 0) AS VLR_BASE_ICMS_IT
               , PEDIT.VLR_PROD_PED AS VLR_PROD_PED_IT
               , (PEDIT.VLR_IT * CAST(PEDIT.QT_IT AS MONEY)) AS VLR_TOT_IT
               , ISNULL(PEDIT.VLR_SUFRAMA, 0) AS VLR_SUFRAMA_IT
               , ISNULL(PEDIT.VLR_ISENTO, 0) AS VLR_ISENTO_IT
               , 0 AS VLR_OUTROS_IT
               , PEDIT.PERC_DESC AS PERC_DESC_IT
               , PEDIT.VLR_DESC AS VLR_DESC_IT
               , 0 AS PERC_DESC_CTR
               , 0 AS PERC_COMI
               , 0 AS PERC_COMI_CTR
               , PEDIT.ORD_GRAVA AS CD_IT
               , EST_PROD.PIS_COFINS
               , ISNULL(PEDIT.PERC_REDU_BASE_SUBS, 0) AS PERC_REDU_BASE_SUBS_IT
               , ISNULL(PEDIT.PERC_REDU_BASE_ICMS, 0) AS PERC_REDU_BASE_ICMS_IT
               , ISNULL(PEDIT.VLR_PROD_FRETE, 0) AS VLR_PROD_FRETE_IT
               , EST_PROD.LISTA_PROD
               , ISNULL(PEDIT.VLR_BASE_PIS, 0) AS VLR_BASE_PIS_IT
               , ISNULL(PEDIT.VLR_PIS, 0) AS VLR_PIS_IT
               , ISNULL(PEDIT.PERC_ALIQ_PIS, 0) AS PERC_ALIQ_PIS_IT
               , ISNULL(PEDIT.VLR_BASE_COFINS, 0) AS VLR_BASE_COFINS_IT
               , ISNULL(PEDIT.VLR_COFINS, 0) AS VLR_COFINS_IT
               , ISNULL(PEDIT.PERC_ALIQ_COFINS, 0) AS PERC_ALIQ_COFINS_IT
               , ISNULL(PEDIT.VLR_BASE_ICMS_RET, 0) AS VLR_BASE_ICMS_RET_IT
               , ISNULL(PEDIT.VLR_ICMS_RETIDO, 0) AS VLR_ICMS_RET_IT
               , ISNULL(PEDIT.VLR_PMC, 0) AS VLR_PMC
               , ISNULL(PEDIT.VLR_OUTROS_DESPESAS, 0) AS VLR_OUTROS_DESPESAS_IT
               , CASE
                     WHEN PRC_FILIAL.REGIME_TRIBUTARIO IN(1, 2)
                     THEN ISNULL(
                                (
                                    SELECT TOP 1 ISNULL(EST_TRIB_SIMPLES.CD_TRIB_FC, 0)
                                    FROM EST_TRIB EST_TRIB_SIMPLES
                                    WHERE PEDIT.CD_TRIB = EST_TRIB_SIMPLES.CD_TRIB_SIMPLES
                                          AND ISNULL(EST_TRIB_SIMPLES.CD_TRIB_SIMPLES, 0) > 0
                                ), 0)
                     ELSE 0
                 END AS CD_SIT_OPERA_SIMPLES_NACIO
               -- COMENTADO VIA FARMAGOI2931, 0 AS MODALI_BASE_ICMS_SUBST
               -- COMENTADO VIA FARMAGOI2931, 0 AS MODALI_BASE_ICMS
               , 0 AS VLR_CRED_BASE_SN_IT
               , 0 AS VLR_CRED_ICMS_SN_IT
               , 0 AS CST_COFINS
               , 0 AS CST_PIS
               , 0 AS PIS_COFINS_RECALCULADO
               , CASE 
					WHEN ISNULL(PEDIT.ALIQ_ICMS_INTERNO, 0) = 0 
					THEN ISNULL(TRIB.ALIQ_ICMS_INTERNO,0) + ISNULL(POBR.PERC_ALIQ,0)
					ELSE ISNULL(PEDIT.ALIQ_ICMS_INTERNO, 0) 
				END AS ALIQ_ICMS_INTERNO
               , ISNULL(PEDIT.PERC_IVA, 0) AS PERC_IVA
               , EST_PROD_CPL.VLR_CUSTO_MD
               , EST_PROD_CPL.TP_PROD
               , ISNULL(EST_PROD.TIPO_TRIBUTACAO_PIS_COFINS, 0) AS TIPO_TRIBUTACAO_PIS_COFINS
				 , ISNULL(EST_PROD.FLAG_EXCECAO_PIS_COFINS, 0) AS FLAG_EXCECAO_PIS_COFINS
               , ISNULL(EST_PROD.SIGLA_EXCECAO_PIS_COFINS, '') AS SIGLA_EXCECAO_PIS_COFINS
               , '' AS XPED_IT
               , 0 AS N_ITEM_PED
               , CASE
                     WHEN COALESCE(CONF.CD_EMP, 0) = 0
                     THEN CAST(ISNULL(WMS.CD_PED_WMS, '0') AS    VARCHAR(50))
                     ELSE ISNULL(WMS.CD_PED_WMS_REFERENCIA, '0')
                 END AS CD_PED_WMS               
			   , ISNULL(TRESSUP.CD_CTR, 0) AS CD_RESSUP
               , ISNULL(EST_PROD.CTR_PMC, 0) AS CTR_PMC
               , ISNULL(PRC_FILIAL.CTR_LOTE, 0) AS CTR_LOTE_FILIAL
               , ISNULL(EST_PROD.CTR_LOTE, 0) AS CTR_LOTE_PROD
               , EST_PROD_CPL.VLR_CUSTO_GER
               , ISNULL(PED.FLAG_NAO_CALCULAR_IMPOSTO, 0) AS FLAG_NAO_CALCULAR_IMPOSTO
               , ISNULL(VLR_RESSARCIMENTO_BASE_SUBST, 0) AS VLR_RESSARCIMENTO_BASE_SUBST
               , ISNULL(VLR_RESSARCIMENTO_ICMS_SUBST, 0) AS VLR_RESSARCIMENTO_ICMS_SUBST
               , ISNULL(VLR_ADJ_BASE_ICMS, 0) AS VLR_ADJ_BASE_ICMS
               , ISNULL(VLR_ADJ_ICMS, 0) AS VLR_ADJ_ICMS
               , ROUND(((((PEDIT.VLR_IT * PEDIT.QT_IT) - PEDIT.VLR_DESC + PEDIT.VLR_OUTROS_DESPESAS) * PEDIT.PERC_IPI) / 100), 2) AS VLR_IPI_IT
               , ISNULL(PRC_FILIAL.CD_BC, 0) AS CD_BC
               , ISNULL(NFE_REFERENCIADA.NR_AUTORIZADOR, ISNULL(NFE.NR_AUTORIZADOR, '')) AS NR_AUTORIZADOR
               , ISNULL(NFE_REFERENCIADA.NR_ECF, 0) AS NR_ECF
               , ISNULL(NFE_REFERENCIADA.CD_CX, 0) AS CD_CX
               , ISNULL(NFE_REFERENCIADA.MODELO, '') AS MODELO
               , ISNULL(EST_PROD.CONTROLE_SNGPC, 0) AS CONTROLE_SNGPC
               , EST_PROD.NR_NCM
               , ISNULL(PEDIT.VLR_CUSTO_ACERTO, 0) AS VLR_CUSTO_ACERTO
               , ISNULL(PEDIT.VLR_ICMS_DESONERADO, 0) AS VLR_ICMS_DESONERADO
               , ISNULL(PEDIT.ICMS_DESONERADO_MOTIVO, 0) AS ICMS_DESONERADO_MOTIVO
               , ISNULL(PEDIT.PERC_ICMS_DESTINO_DIFAL, 0) AS PERC_ICMS_DESTINO_DIFAL
               , ISNULL(PEDIT.PERC_ICMS_ORIGEM_DIFAL, 0) AS PERC_ICMS_ORIGEM_DIFAL
               , ISNULL(PEDIT.GERAR_DIFAL, 0) AS GERAR_DIFAL
               , ISNULL(PORC.CD_ORC, 0) AS PED_TELEVENDAS
               , ISNULL(EST_PROD.PESO_PROD_VD, 0) AS PESO_PROD_VD
               , ISNULL(EST_PROD.PESO_PROD_VD_LIQ, 0) AS PESO_PROD_VD_LIQ
               , ISNULL(PEDIT.VLR_BASE_ICMS_OP, 0) AS VLR_BASE_ICMS_OP
               , ISNULL(PEDIT.VLR_ICMS_OP, 0) AS VLR_ICMS_OP
               , ISNULL(PEDIT.PERC_ICMS_OP, 0) AS PERC_ICMS_OP
               , ISNULL(PEDIT.PERC_DIFERIMENTO, 0) AS PERC_DIFERIMENTO
               , ISNULL(PEDIT.VLR_ICMS_DIFERIMENTO, 0) AS VLR_ICMS_DIFERIMENTO
			   , 0 AS TIPO_OPERACAO
			   , ISNULL(PEDIT.ALIQ_ICMS_ENTRADA,0) AS ALIQ_ICMS_ENTRADA
			   , ISNULL(PED.NR_END_DESTINATARIO,0) AS NR_END_DESTINATARIO
			   , ISNULL(PED.PONTO_REF_DESTINATARIO,0) AS PONTO_REF_DESTINATARIO
			   , ISNULL(PED.VLR_FECOP_ST,0) AS VLR_FECOP_ST
			   , ISNULL(PED.VLR_FECOP_RET,0) AS VLR_FECOP_RET
			   , ISNULL(PED.VLR_FECOP,0) AS VLR_FECOP   
			   , ISNULL(PEDIT.VLR_BASE_FECOP_ST,0) AS  IT_VLR_BASE_FECOP_ST
               , ISNULL(PEDIT.VLR_FECOP_ST,0) AS  IT_VLR_FECOP_ST
               , ISNULL(PEDIT.PERC_FECOP_ST,0) AS  IT_PERC_FECOP_ST
               , ISNULL(PEDIT.PERC_FECOP,0) AS  IT_PERC_FECOP
               , ISNULL(PEDIT.VLR_BASE_FECOP,0) AS  IT_VLR_BASE_FECOP
               , ISNULL(PEDIT.VLR_FECOP,0) AS  IT_VLR_FECOP
               , ISNULL(PEDIT.VLR_BASE_FECOP_RET,0) AS  IT_VLR_BASE_FECOP_RET
               , ISNULL(PEDIT.VLR_FECOP_RET,0) AS  IT_VLR_FECOP_RET
               , ISNULL(PEDIT.PERC_FECOP_RET,0) AS  IT_PERC_FECOP_RET
			   , ISNULL(PEDIT.PERC_ICMS_RET,0) AS  IT_PERC_ICMS_RET
			   , ISNULL(PED.FLAG_PRIORIDADE,0) AS FLAG_PRIORIDADE
			   , ISNULL(PEDIT.MODALI_BASE_ICMS,0) AS MODALI_BASE_ICMS                 -------- ADICIONADO VIA FARMAGOI-2931
			   , ISNULL(PEDIT.MODALI_BASE_ICMS_SUBST,0)  AS MODALI_BASE_ICMS_SUBST    -------- ADICIONADO VIA FARMAGOI-2931 
               , ISNULL(PEDIT.VLR_CUSTO_PROD_ORIG, 0) AS IT_VLR_CUSTO_PROD_ORIG -- FARMAGOI-3249
               , ISNULL(PEDIT.CD_BENEF, '') CD_BENEF
			   , ISNULL(PED.FLAG_NAO_ABATER_ICMS_DESONERADO, 1) AS FLAG_NAO_ABATER_ICMS_DESONERADO
			   , ISNULL(PED.VLR_SUBSIDIO_MARKETPLACE, 0) AS VLR_SUBSIDIO_MARKETPLACE
			   , ISNULL(PED.FLAG_VLR_ICMS_DESONERADO_DESCONTO,0) AS FLAG_VLR_ICMS_DESONERADO_DESCONTO
		       , ISNULL(R.CD_EMP,0) AS RESSARC_ADJUDICACAO
			   , ISNULL(R.TIPO,0) AS TIPO_RESSARC_ADJUDICACAO
			   , ISNULL(R.CD_CTR,0) AS CD_CTR_RESSARC_ADJUDICACAO
			   , PEDIT.OBSERVACOES_FISCAIS_CONTRIBUINTE AS OBSERVACOES_FISCAIS_CONTRIBUINTE --NT2021.004
			   , PEDIT.OBS_FISCO AS OBS_FISCO --NT2021.004
			   , ISNULL(PED.DEST_CPF_CNPJ_ENTREGA, '') AS DEST_CPF_CNPJ_ENTREGA
			   ,ISNULL(PEDIT.CD_TRIB_ENTRADA,0) AS IT_CD_TRIB_ENTRADA
          FROM
               EST_PED_VD PED
               INNER JOIN EST_PED_VD_PENDENCIA PEND
               ON PED.CD_EMP = PEND.CD_EMP
                  AND PED.CD_FILIAL = PEND.CD_FILIAL
                  AND PED.CD_PED = PEND.CD_PED
               INNER JOIN GLB_MOV_OP
               ON PED.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
               INNER JOIN EST_PED_VD_IT PEDIT
               ON PED.CD_EMP = PEDIT.CD_EMP
                  AND PED.CD_FILIAL = PEDIT.CD_FILIAL
                  AND PED.CD_PED = PEDIT.CD_PED
               INNER JOIN PRC_FILIAL
               ON PED.CD_EMP = PRC_FILIAL.CD_EMP
                  AND PED.CD_FILIAL = PRC_FILIAL.CD_FILIAL
               INNER JOIN EST_PROD
               ON PEDIT.CD_EMP = EST_PROD.CD_EMP
                  AND PEDIT.CD_PROD = EST_PROD.CD_PROD
               INNER JOIN EST_PROD_UN_MED UN
               ON EST_PROD.CD_EMP = UN.CD_EMP
                  AND EST_PROD.CD_UN_VD = UN.CD_CTR_UN
               INNER JOIN EST_PROD_CPL
               ON PEDIT.CD_EMP = EST_PROD_CPL.CD_EMP
                  AND PEDIT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
                  AND PEDIT.CD_PROD = EST_PROD_CPL.CD_PROD
               LEFT OUTER JOIN EST_PROD_TRANSF_PED_VD TRESSUP
               ON PED.CD_EMP = TRESSUP.CD_EMP
                  AND PED.CD_FILIAL = TRESSUP.CD_FILIAL
                  AND PED.CD_PED = TRESSUP.CD_PED
               LEFT JOIN
          (
              SELECT CD_EMP
                   , CD_FILIAL
                   , CD_CTR
                   , MAX(CD_PED_WMS_REFERENCIA) AS CD_PED_WMS_REFERENCIA
                   , MAX(CD_PED_WMS) AS CD_PED_WMS
              FROM EST_PROD_TRANSF_EST_WMS_SAI
              GROUP BY CD_EMP
                     , CD_FILIAL
                     , CD_CTR
          ) WMS
               ON TRESSUP.CD_EMP = WMS.CD_EMP
                  AND TRESSUP.CD_FILIAL = WMS.CD_FILIAL
                  AND TRESSUP.CD_CTR = WMS.CD_CTR
               LEFT JOIN PRC_EMP_CONFIG CONF
               ON TRESSUP.CD_EMP = CONF.CD_EMP
                  AND CONF.CD_CHAVE = 'IMPRIMIR_PEDIDO_WMS_TERCEIRO'
                  AND CONF.VALOR = '1'
               LEFT OUTER JOIN NFE_REFERENCIADA
               ON PED.CD_EMP = NFE_REFERENCIADA.CD_EMP
                  AND PED.CD_FILIAL = NFE_REFERENCIADA.CD_FILIAL
                  AND PED.CD_PED = NFE_REFERENCIADA.CD_PED
                  AND NFE_REFERENCIADA.ID_ROW = 1
			   LEFT JOIN
          (
              SELECT ROW_NUMBER() OVER(PARTITION BY E.CD_EMP
                                                  , E.CD_FILIAL
                                                  , E.CD_PED ORDER BY E.CD_EMP
                                                                    , E.CD_FILIAL
                                                                    , E.CD_PED) AS ID_ROW
                   , E.CD_EMP
                   , E.CD_FILIAL
                   , E.CD_PED
                   , SN.NR_AUTORIZADOR
              FROM
                   EST_NF_ENT_EST_PED_VD E
                   INNER JOIN EST_NF_ENT_EST_NF_SAI_TRANSF T
                   ON E.CD_EMP = T.CD_EMP
                      AND E.CD_FILIAL = T.CD_FIL_DEST
                      AND E.CD_NF = T.CD_NF_ENT
					INNER JOIN EST_PED_VD_PENDENCIA PEND
				   ON E.CD_EMP = PEND.CD_EMP
                  AND E.CD_FILIAL = PEND.CD_FILIAL
                  AND E.CD_PED = PEND.CD_PED
                   INNER JOIN EST_NF_SAI_NFE SN
                   ON T.CD_EMP = SN.CD_EMP
                      AND T.CD_FIL_ORIG = SN.CD_FILIAL
                      AND T.CD_NF_SAI = SN.CD_NF
          ) NFE
				   ON PED.CD_EMP	= NFE.CD_EMP
                  AND PED.CD_FILIAL = NFE.CD_FILIAL
                  AND PED.CD_PED	= NFE.CD_PED
                  AND NFE.ID_ROW = 1
               LEFT OUTER JOIN EST_NF_SAI_EST_PED_VD PNFSAI
               ON PED.CD_EMP = PNFSAI.CD_EMP
                  AND PED.CD_FILIAL = PNFSAI.CD_FILIAL
                  AND PED.CD_PED = PNFSAI.CD_PED
               LEFT OUTER JOIN EST_PED_VD_CONF PCONF
               ON PED.CD_EMP = PCONF.CD_EMP
                  AND PED.CD_FILIAL = PCONF.CD_FILIAL
                  AND PED.CD_PED = PCONF.CD_PED
               LEFT OUTER JOIN TELE_ORC_EST_PED_VD PORC
               ON PED.CD_EMP = PORC.CD_EMP
                  AND PED.CD_FILIAL = PORC.CD_FILIAL
                  AND PED.CD_PED = PORC.CD_PED
				LEFT JOIN EST_PED_VD_DEV_RESSARCIMENTO  R ON PED.CD_EMP = r.CD_EMP
					AND PED.CD_FILIAL = R.CD_FILIAL
					AND PED.CD_PED = R.CD_PED
				LEFT JOIN V_PRC_FILIAL VF ON VF.CD_FILIAL = PED.CD_FILIAL
			    OUTER APPLY (SELECT ALIQ_ICMS as ALIQ_ICMS_INTERNO
							FROM EST_TRIB_ALIQ_ICMS
							WHERE UF_ORIG = UF_DEST
							AND UF_ORIG = VF.UF) TRIB
				
				LEFT JOIN EST_PROD_NCM_CADASTRO_COMB_POBREZA POBR ON EST_PROD.NR_NCM = POBR.NR_NCM COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS 
																	AND VF.UF = POBR.UF COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
					
          WHERE PEND.FLAG_REALIZAR_FAT IN(1, 2) AND PEDIT.QT_IT > 0
		  AND ISNULL(R.TIPO,0 ) = 0 


		  UNION ALL
		 SELECT PED.CD_EMP
               , PED.CD_FILIAL
               , 0 AS CD_NF
               , PED.CD_PED
               , PED.CD_CLI
               , CONVERT( CHAR(10), DBO.GETDATE_FUSO_HORARIO(PED.CD_FILIAL), 112) AS DT_EMI_NF
               , 0 AS NF_NF
               , ISNULL(
                       (
                           SELECT TOP 1 CD_NF_SERIE
                           FROM PRC_FILIAL_NF_SERIES FISERIE
                           WHERE PED.CD_EMP = FISERIE.CD_EMP
                                 AND PED.CD_FILIAL = FISERIE.CD_FILIAL
                                 AND FISERIE.NF_SERIE_PD = 1
                       ), 0) AS CD_NF_SERIE
               , 0 AS VLR_NF_CAB
               , 0 AS VLR_ICMS_CAB
               , ISNULL(PED.VLR_FRETE, 0) AS VLR_FRETE_CAB
               , 0 AS VLR_OUTROS_CAB
               , 0 AS VLR_BASE_ICMS_CAB
               , 0 AS ALIQ_ICMS_CAB
               , 0 AS VLR_TOT_PROD_CAB
               , PED.CD_NT_MOV
               , 0 AS VLR_DESC_CAB
               , 0 AS VLR_BASE_ICMS_SUBS
               , 0 AS VLR_ICMS_SUBS_CAB
               , 0 AS VLR_IPI_CAB
               , CONVERT( CHAR(10), GETDATE(), 112) AS DT_CAD
               , 0 AS DEV
               , ISNULL(PED.CD_VEND, 0) AS CD_VEND
               , PED.CD_COND_PGTO
               , 0 AS COB
               , 0 AS STS_NF
               , 0 AS TP_NF
               , ISNULL(LEFT(PED.OBS, 150), '') AS OBS1
               , ISNULL(LEFT(PED.OBS_NF1, 150), '') AS OBS2
               , ISNULL(LEFT(PED.OBS_NF2, 150), '') AS OBS3
               , ISNULL(LEFT(PED.OBS_NF4, 150), '') AS OBS4
               , ISNULL(LEFT(PED.OBS_NF5, 150), '') AS OBS5
               , ISNULL(LEFT(PED.OBS_NF6, 150), '') AS OBS6
               , ISNULL(LEFT(PED.OBS_NF7, 150), '') AS OBS7
               , ISNULL(LEFT(PED.OBS_NF8, 150), '') AS OBS8
               , ISNULL(LEFT(PED.OBS_NF9, 150), '') AS OBS9
               , ISNULL(LEFT(PED.OBS_NF10, 150), '') AS OBS10
               , ISNULL(LEFT(PED.OBS_NF11, 150), '') AS OBS11
               , ISNULL(CD_TRANSP, 0) AS CD_TRANSP
               , ISNULL(PED.QT_VOL, 0) AS QT_VOL
               , ISNULL(PED.ESP_VOL, '') AS ESP_VOL
               , ISNULL(PED.MC_VOL, '') AS MC_VOL
               , ISNULL(PED.NR_VOL, 0) AS NR_VOL
               , ISNULL(PED.PESO_VOL, 0) AS PESO_VOL
               , ISNULL(PED.PESO_LIQ_VOL, 0) AS PESO_LIQ_VOL
               , ISNULL(PED.EMAIL_TRANSP, '') AS EMAIL_TRANSP
               , ISNULL(PED.FRETE, 0) TP_FRETE
               , 0 AS TP_DEV_NF
               , NULL AS DT_CANCEL
               , 0 AS VLR_ISENTAS_CAB
               , 0 AS VLR_OUTRAS_CAB
               , 0 AS CD_NF_ENT
               , ISNULL(PNFSAI.CD_NF, 0) AS CD_NF_SAI
               , ISNULL(PCONF.CD_USU, PED.CD_USU) AS CD_USU
               , 0 AS VLR_PROD_ICMS_SUBS_CAB
               , NULL AS DT_ULT_ALT
               , 0 AS LANC_EFETU
               , '' AS NM_COMPRADOR
               , 0 AS VLR_BASE_ICMS_IT_CAB
               , 0 AS NF_PROD_SERV
               , CONVERT( CHAR(10), DBO.GETDATE_FUSO_HORARIO(PED.CD_FILIAL), 108) AS HR_EMI_NF
               , 0 AS VLR_DESC_CORPO
               , '' AS INF_DESCONTO
               , ISNULL(NM_TRANSP, '') AS DS_TRANSP
               , ISNULL(PLACA_VEIC, '') AS PLACA_VEIC
               , ISNULL(PLACA_UF, '') AS PLACA_UF
               , ISNULL(CGC_CPF_TRANSP, '') AS CGC_CPF_TRANSP
               , ISNULL(ENDE_TRANSP, '') AS ENDE_TRANSP
               , ISNULL(DS_CID_TRANSP, '') AS DS_CID_TRANSF
               , ISNULL(UF_TRANSP, '') AS UF_TRANSP
               , ISNULL(INSC_EST_TRANSP, '') AS INSC_EST_TRANSP
               , 0 AS VLR_ISSQN_CAB
               , 0 AS VLR_SERVICO_CAB
               , 0 AS PERC_ISSQN_CAB
               , 0 AS VLR_SULFRAMA_CAB
               , 0 AS PEND_ENTRADA
               , 0 AS NR_SELO_SAIDA
               , 0 AS CD_MT_CANCEL
               , 0 AS NR_FORMULARIO
               , 0 AS CD_MOT_EMIS_NF
               , 0 AS QT_CX_VOL
               , 0 AS R_E_C_N_O_
               , 1 AS FLAG_NF_PROD_TOTAL_BRUTO
               , 0 AS FLAG_IGNORAR_CONTROL
               , 0 AS VLR_BASE_ICMS_RET_CAB
               , 0 AS VLR_ICMS_RET_CAB
               , 0 AS NF_MANUAL
               , ISNULL(PED.BAIRRO_DESTINATARIO, '') AS BAIRRO_DESTINATARIO
               , '' AS BAIRRO_EMITENTE
               , ISNULL(PED.CEP_DESTINATARIO, '') AS CEP_DESTINATARIO
               , '' AS CEP_EMITENTE
               , ISNULL(PED.CIDADE_DESTINATARIO, '') AS CIDADE_DESTINATARIO
               , '' AS CIDADE_EMITENTE
               , '' AS CNPJ_DESTINATARIO
               , '' AS CNPJ_EMITENTE
               , ISNULL(PED.END_DESTINATARIO, '') AS END_DESTINATARIO
               , '' AS END_EMITENTE
               , '' AS INSC_ESTADUAL_DESTINATARIO
               , '' AS INSC_ESTADUAL_EMITENTE
               , '' AS NT_OPERACAO
               , '' AS RZ_DESTINATARIO
               , '' AS RZ_EMITENTE
               , '' AS RZ_TRANSPORTADOR
               , ISNULL(PED.UF_DESTINATARIO, '') AS UF_DESTINATARIO
               , '' AS UF_EMITENTE
               , '' AS APLICATIVO
               , '' AS VERSAO_APLICATIVO
               , 0 AS CD_CID_TRANSP
               , 0 AS CD_CID_EMITENTE
               , ISNULL(PED.CD_CID_DESTINATARIO, 0) AS CD_CID_DESTINATARIO
               , 0 AS CD_NT_OP_TRANSF_ENTRADA
               , 0 AS FLAG_NOTA_INTEGRACAO
               , '' AS XML_NOTA
               , '' AS XPED_NOTA_FISCAL
               , 0 AS NFE_REJEITADA
			   , ISNULL(PED.FLAG_FRETE_BASE_ICMS, 0) AS FLAG_FRETE_BASE_ICMS
               , PEDIT.CD_PROD
               , LEFT(EST_PROD.DS_PROD, 50) AS DS_PROD
               , PEDIT.VLR_IT
               , CAST(PEDIT.QT_IT AS MONEY) AS QT_IT
               , ISNULL(PEDIT.VLR_ICMS_IT, 0) AS VLR_ICMS_IT
               , ISNULL(PEDIT.ALIQ_ICMS, 0) AS ALIQ_ICMS_IT
               , PEDIT.CD_TRIB
               , UN.DS_UN
               , UN.TP_UN
               , PEDIT.PERC_IPI
               , CASE
                     WHEN ISNULL(PEDIT.VLR_CUSTO, 0) > 0
                     THEN ISNULL(PEDIT.VLR_CUSTO, 0)
                     ELSE ISNULL(EST_PROD_CPL.VLR_CUSTO, 0)
                 END AS VLR_CUSTO
               , ISNULL(PEDIT.VLR_BASE_ICMS_SUBS, 0) AS VLR_BASE_SUBS_IT
               , ISNULL(PEDIT.VLR_ICMS_SUBS, 0) AS VLR_ICMS_SUBS_IT
               , CASE
                     WHEN GLB_MOV_OP.TP_ESTQ = 0
                     THEN EST_PROD_CPL.QT_EST
                     WHEN GLB_MOV_OP.TP_ESTQ = 1
                     THEN EST_PROD_CPL.QT_EST_FLUT
                     WHEN GLB_MOV_OP.TP_ESTQ = 2
                     THEN EST_PROD_CPL.QT_EST_EM_TERC
                     WHEN GLB_MOV_OP.TP_ESTQ = 3
                     THEN EST_PROD_CPL.QT_EST_DE_TERC
                     ELSE 0
                 END AS QT_EST_ANT
               , 0 AS CD_NT_OP
               , ISNULL(PEDIT.VLR_BASE_ICMS_IT, 0) AS VLR_BASE_ICMS_IT
               , PEDIT.VLR_PROD_PED AS VLR_PROD_PED_IT
               , (PEDIT.VLR_IT * CAST(PEDIT.QT_IT AS MONEY)) AS VLR_TOT_IT
         , ISNULL(PEDIT.VLR_SUFRAMA, 0) AS VLR_SUFRAMA_IT
               , ISNULL(PEDIT.VLR_ISENTO, 0) AS VLR_ISENTO_IT
               , 0 AS VLR_OUTROS_IT
               , PEDIT.PERC_DESC AS PERC_DESC_IT
               , PEDIT.VLR_DESC AS VLR_DESC_IT
               , 0 AS PERC_DESC_CTR
               , 0 AS PERC_COMI
               , 0 AS PERC_COMI_CTR
               , PEDIT.ORD_GRAVA AS CD_IT
               , EST_PROD.PIS_COFINS
               , ISNULL(PEDIT.PERC_REDU_BASE_SUBS, 0) AS PERC_REDU_BASE_SUBS_IT
               , ISNULL(PEDIT.PERC_REDU_BASE_ICMS, 0) AS PERC_REDU_BASE_ICMS_IT
               , ISNULL(PEDIT.VLR_PROD_FRETE, 0) AS VLR_PROD_FRETE_IT
               , EST_PROD.LISTA_PROD
               , ISNULL(PEDIT.VLR_BASE_PIS, 0) AS VLR_BASE_PIS_IT
               , ISNULL(PEDIT.VLR_PIS, 0) AS VLR_PIS_IT
               , ISNULL(PEDIT.PERC_ALIQ_PIS, 0) AS PERC_ALIQ_PIS_IT
               , ISNULL(PEDIT.VLR_BASE_COFINS, 0) AS VLR_BASE_COFINS_IT
               , ISNULL(PEDIT.VLR_COFINS, 0) AS VLR_COFINS_IT
               , ISNULL(PEDIT.PERC_ALIQ_COFINS, 0) AS PERC_ALIQ_COFINS_IT
               , ISNULL(PEDIT.VLR_BASE_ICMS_RET, 0) AS VLR_BASE_ICMS_RET_IT
               , ISNULL(PEDIT.VLR_ICMS_RETIDO, 0) AS VLR_ICMS_RET_IT
               , ISNULL(PEDIT.VLR_PMC, 0) AS VLR_PMC
               , ISNULL(PEDIT.VLR_OUTROS_DESPESAS, 0) AS VLR_OUTROS_DESPESAS_IT
               , CASE
                     WHEN PRC_FILIAL.REGIME_TRIBUTARIO IN(1, 2)
                     THEN ISNULL(
                                (
                                    SELECT TOP 1 ISNULL(EST_TRIB_SIMPLES.CD_TRIB_FC, 0)
                                    FROM EST_TRIB EST_TRIB_SIMPLES
                                    WHERE PEDIT.CD_TRIB = EST_TRIB_SIMPLES.CD_TRIB_SIMPLES
                                          AND ISNULL(EST_TRIB_SIMPLES.CD_TRIB_SIMPLES, 0) > 0
                                ), 0)
                     ELSE 0
                 END AS CD_SIT_OPERA_SIMPLES_NACIO
               -- COMENTADO VIA FARMAGOI2931, 0 AS MODALI_BASE_ICMS_SUBST
               -- COMENTADO VIA FARMAGOI2931, 0 AS MODALI_BASE_ICMS
               , 0 AS VLR_CRED_BASE_SN_IT
               , 0 AS VLR_CRED_ICMS_SN_IT
               , 0 AS CST_COFINS
               , 0 AS CST_PIS
               , 0 AS PIS_COFINS_RECALCULADO
               , CASE 
					WHEN ISNULL(PEDIT.ALIQ_ICMS_INTERNO, 0) = 0 
					THEN ISNULL(TRIB.ALIQ_ICMS_INTERNO,0) + ISNULL(POBR.PERC_ALIQ,0)
					ELSE ISNULL(PEDIT.ALIQ_ICMS_INTERNO, 0) 
				END  AS ALIQ_ICMS_INTERNO
               , ISNULL(PEDIT.PERC_IVA, 0) AS PERC_IVA
               , EST_PROD_CPL.VLR_CUSTO_MD
               , EST_PROD_CPL.TP_PROD
               , ISNULL(EST_PROD.TIPO_TRIBUTACAO_PIS_COFINS, 0) AS TIPO_TRIBUTACAO_PIS_COFINS
               , ISNULL(EST_PROD.FLAG_EXCECAO_PIS_COFINS, 0) AS FLAG_EXCECAO_PIS_COFINS
               , ISNULL(EST_PROD.SIGLA_EXCECAO_PIS_COFINS, '') AS SIGLA_EXCECAO_PIS_COFINS
               , '' AS XPED_IT
               , 0 AS N_ITEM_PED
               , CASE
                     WHEN COALESCE(CONF.CD_EMP, 0) = 0
                     THEN CAST(ISNULL(WMS.CD_PED_WMS, '0') AS    VARCHAR(50))
                     ELSE ISNULL(WMS.CD_PED_WMS_REFERENCIA, '0')
                 END AS CD_PED_WMS               
			   , ISNULL(TRESSUP.CD_CTR, 0) AS CD_RESSUP
               , ISNULL(EST_PROD.CTR_PMC, 0) AS CTR_PMC
               , ISNULL(PRC_FILIAL.CTR_LOTE, 0) AS CTR_LOTE_FILIAL
               , ISNULL(EST_PROD.CTR_LOTE, 0) AS CTR_LOTE_PROD
               , EST_PROD_CPL.VLR_CUSTO_GER
               , ISNULL(PED.FLAG_NAO_CALCULAR_IMPOSTO, 0) AS FLAG_NAO_CALCULAR_IMPOSTO
               , ISNULL(VLR_RESSARCIMENTO_BASE_SUBST, 0) AS VLR_RESSARCIMENTO_BASE_SUBST
               , ISNULL(VLR_RESSARCIMENTO_ICMS_SUBST, 0) AS VLR_RESSARCIMENTO_ICMS_SUBST
               , ISNULL(VLR_ADJ_BASE_ICMS, 0) AS VLR_ADJ_BASE_ICMS
               , ISNULL(VLR_ADJ_ICMS, 0) AS VLR_ADJ_ICMS
               , ROUND(((((PEDIT.VLR_IT * PEDIT.QT_IT) - PEDIT.VLR_DESC + PEDIT.VLR_OUTROS_DESPESAS) * PEDIT.PERC_IPI) / 100), 2) AS VLR_IPI_IT
               , ISNULL(PRC_FILIAL.CD_BC, 0) AS CD_BC
               ,   '' AS NR_AUTORIZADOR
               , 0 AS NR_ECF
               , 0AS CD_CX
               ,  '' AS MODELO
               , ISNULL(EST_PROD.CONTROLE_SNGPC, 0) AS CONTROLE_SNGPC
               , EST_PROD.NR_NCM
               , ISNULL(PEDIT.VLR_CUSTO_ACERTO, 0) AS VLR_CUSTO_ACERTO
               , ISNULL(PEDIT.VLR_ICMS_DESONERADO, 0) AS VLR_ICMS_DESONERADO
               , ISNULL(PEDIT.ICMS_DESONERADO_MOTIVO, 0) AS ICMS_DESONERADO_MOTIVO
               , ISNULL(PEDIT.PERC_ICMS_DESTINO_DIFAL, 0) AS PERC_ICMS_DESTINO_DIFAL
               , ISNULL(PEDIT.PERC_ICMS_ORIGEM_DIFAL, 0) AS PERC_ICMS_ORIGEM_DIFAL
               , ISNULL(PEDIT.GERAR_DIFAL, 0) AS GERAR_DIFAL
               , ISNULL(PORC.CD_ORC, 0) AS PED_TELEVENDAS
               , ISNULL(EST_PROD.PESO_PROD_VD, 0) AS PESO_PROD_VD
               , ISNULL(EST_PROD.PESO_PROD_VD_LIQ, 0) AS PESO_PROD_VD_LIQ
               , ISNULL(PEDIT.VLR_BASE_ICMS_OP, 0) AS VLR_BASE_ICMS_OP
               , ISNULL(PEDIT.VLR_ICMS_OP, 0) AS VLR_ICMS_OP
               , ISNULL(PEDIT.PERC_ICMS_OP, 0) AS PERC_ICMS_OP
               , ISNULL(PEDIT.PERC_DIFERIMENTO, 0) AS PERC_DIFERIMENTO
               , ISNULL(PEDIT.VLR_ICMS_DIFERIMENTO, 0) AS VLR_ICMS_DIFERIMENTO
			   , 0 AS TIPO_OPERACAO
			   , ISNULL(PEDIT.ALIQ_ICMS_ENTRADA,0) AS ALIQ_ICMS_ENTRADA
			   ,ISNULL(PED.NR_END_DESTINATARIO,0) AS NR_END_DESTINATARIO
			   ,ISNULL(PED.PONTO_REF_DESTINATARIO,0) AS PONTO_REF_DESTINATARIO
			   ,ISNULL(PED.VLR_FECOP_ST,0) AS VLR_FECOP_ST
			   ,ISNULL(PED.VLR_FECOP_RET,0) AS VLR_FECOP_RET
			   ,ISNULL(PED.VLR_FECOP,0) AS VLR_FECOP   
			   ,ISNULL(PEDIT.VLR_BASE_FECOP_ST,0) AS  IT_VLR_BASE_FECOP_ST
               ,ISNULL(PEDIT.VLR_FECOP_ST,0) AS  IT_VLR_FECOP_ST
               ,ISNULL(PEDIT.PERC_FECOP_ST,0) AS  IT_PERC_FECOP_ST
               ,ISNULL(PEDIT.PERC_FECOP,0) AS  IT_PERC_FECOP
               ,ISNULL(PEDIT.VLR_BASE_FECOP,0) AS  IT_VLR_BASE_FECOP
               ,ISNULL(PEDIT.VLR_FECOP,0) AS  IT_VLR_FECOP
               ,ISNULL(PEDIT.VLR_BASE_FECOP_RET,0) AS  IT_VLR_BASE_FECOP_RET
               ,ISNULL(PEDIT.VLR_FECOP_RET,0) AS  IT_VLR_FECOP_RET
               ,ISNULL(PEDIT.PERC_FECOP_RET,0) AS  IT_PERC_FECOP_RET
			   ,ISNULL(PEDIT.PERC_ICMS_RET,0) AS  IT_PERC_ICMS_RET
			   ,ISNULL(PED.FLAG_PRIORIDADE,0) AS FLAG_PRIORIDADE
			   ,ISNULL(PEDIT.MODALI_BASE_ICMS,0) AS MODALI_BASE_ICMS                
			   ,ISNULL(PEDIT.MODALI_BASE_ICMS_SUBST,0)  AS MODALI_BASE_ICMS_SUBST   
               ,ISNULL(PEDIT.VLR_CUSTO_PROD_ORIG, 0) AS IT_VLR_CUSTO_PROD_ORIG 
               ,ISNULL(PEDIT.CD_BENEF, '') CD_BENEF
               ,ISNULL(PED.FLAG_NAO_ABATER_ICMS_DESONERADO, 1) AS FLAG_NAO_ABATER_ICMS_DESONERADO
			   ,ISNULL(PED.VLR_SUBSIDIO_MARKETPLACE, 0) AS VLR_SUBSIDIO_MARKETPLACE
			   ,ISNULL(PED.FLAG_VLR_ICMS_DESONERADO_DESCONTO,0) AS FLAG_VLR_ICMS_DESONERADO_DESCONTO
			   ,1 AS RESSARC_ADJUDICACAO
			   ,ISNULL(R.TIPO,0) AS TIPO_RESSARC_ADJUDICACAO
			   ,ISNULL(R.CD_CTR,0) AS CD_CTR_RESSARC_ADJUDICACAO
			   ,PEDIT.OBSERVACOES_FISCAIS_CONTRIBUINTE AS OBSERVACOES_FISCAIS_CONTRIBUINTE --NT2021.004
			   ,PEDIT.OBS_FISCO AS OBS_FISCO --NT2021.004
			   ,ISNULL(PED.DEST_CPF_CNPJ_ENTREGA, '') AS DEST_CPF_CNPJ_ENTREGA
			   ,ISNULL(PEDIT.CD_TRIB_ENTRADA,0) AS IT_CD_TRIB_ENTRADA
          FROM
               EST_PED_VD PED
               INNER JOIN EST_PED_VD_PENDENCIA PEND
               ON PED.CD_EMP = PEND.CD_EMP
                  AND PED.CD_FILIAL = PEND.CD_FILIAL
                  AND PED.CD_PED = PEND.CD_PED
               INNER JOIN GLB_MOV_OP
               ON PED.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
               INNER JOIN EST_PED_VD_IT PEDIT
               ON PED.CD_EMP = PEDIT.CD_EMP
                  AND PED.CD_FILIAL = PEDIT.CD_FILIAL
                  AND PED.CD_PED = PEDIT.CD_PED
               INNER JOIN PRC_FILIAL
               ON PED.CD_EMP = PRC_FILIAL.CD_EMP
                  AND PED.CD_FILIAL = PRC_FILIAL.CD_FILIAL
               INNER JOIN EST_PROD
               ON PEDIT.CD_EMP = EST_PROD.CD_EMP
                  AND PEDIT.CD_PROD = EST_PROD.CD_PROD
               INNER JOIN EST_PROD_UN_MED UN
               ON EST_PROD.CD_EMP = UN.CD_EMP
                  AND EST_PROD.CD_UN_VD = UN.CD_CTR_UN
               INNER JOIN EST_PROD_CPL
               ON PEDIT.CD_EMP = EST_PROD_CPL.CD_EMP
                  AND PEDIT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
                  AND PEDIT.CD_PROD = EST_PROD_CPL.CD_PROD
               LEFT OUTER JOIN EST_PROD_TRANSF_PED_VD TRESSUP
               ON PED.CD_EMP = TRESSUP.CD_EMP
                  AND PED.CD_FILIAL = TRESSUP.CD_FILIAL
                  AND PED.CD_PED = TRESSUP.CD_PED
               LEFT JOIN
          (
              SELECT CD_EMP
                   , CD_FILIAL
                   , CD_CTR
                   , MAX(CD_PED_WMS_REFERENCIA) AS CD_PED_WMS_REFERENCIA
                   , MAX(CD_PED_WMS) AS CD_PED_WMS
              FROM EST_PROD_TRANSF_EST_WMS_SAI
              GROUP BY CD_EMP
                     , CD_FILIAL
                     , CD_CTR
          ) WMS
               ON TRESSUP.CD_EMP = WMS.CD_EMP
                  AND TRESSUP.CD_FILIAL = WMS.CD_FILIAL
                  AND TRESSUP.CD_CTR = WMS.CD_CTR
               LEFT JOIN PRC_EMP_CONFIG CONF
               ON TRESSUP.CD_EMP = CONF.CD_EMP
                  AND CONF.CD_CHAVE = 'IMPRIMIR_PEDIDO_WMS_TERCEIRO'
                  AND CONF.VALOR = '1'
			   LEFT JOIN
          (
              SELECT ROW_NUMBER() OVER(PARTITION BY E.CD_EMP
                                                  , E.CD_FILIAL
                                                  , E.CD_PED ORDER BY E.CD_EMP
                                                                    , E.CD_FILIAL
                                                                    , E.CD_PED) AS ID_ROW
                   , E.CD_EMP
                   , E.CD_FILIAL
                   , E.CD_PED
                   , SN.NR_AUTORIZADOR
              FROM
                   EST_NF_ENT_EST_PED_VD E
                   INNER JOIN EST_NF_ENT_EST_NF_SAI_TRANSF T
                   ON E.CD_EMP = T.CD_EMP
                      AND E.CD_FILIAL = T.CD_FIL_DEST
                      AND E.CD_NF = T.CD_NF_ENT
					INNER JOIN EST_PED_VD_PENDENCIA PEND
				   ON E.CD_EMP = PEND.CD_EMP
                  AND E.CD_FILIAL = PEND.CD_FILIAL
                  AND E.CD_PED = PEND.CD_PED
                   INNER JOIN EST_NF_SAI_NFE SN
                   ON T.CD_EMP = SN.CD_EMP
                      AND T.CD_FIL_ORIG = SN.CD_FILIAL
                      AND T.CD_NF_SAI = SN.CD_NF
          ) NFE
				   ON PED.CD_EMP	= NFE.CD_EMP
                  AND PED.CD_FILIAL = NFE.CD_FILIAL
                  AND PED.CD_PED	= NFE.CD_PED
                  AND NFE.ID_ROW = 1
               LEFT OUTER JOIN EST_NF_SAI_EST_PED_VD PNFSAI
               ON PED.CD_EMP = PNFSAI.CD_EMP
                  AND PED.CD_FILIAL = PNFSAI.CD_FILIAL
                  AND PED.CD_PED = PNFSAI.CD_PED
               LEFT OUTER JOIN EST_PED_VD_CONF PCONF
               ON PED.CD_EMP = PCONF.CD_EMP
                  AND PED.CD_FILIAL = PCONF.CD_FILIAL
                  AND PED.CD_PED = PCONF.CD_PED
               LEFT OUTER JOIN TELE_ORC_EST_PED_VD PORC
               ON PED.CD_EMP = PORC.CD_EMP
                  AND PED.CD_FILIAL = PORC.CD_FILIAL
                  AND PED.CD_PED = PORC.CD_PED
			  INNER JOIN EST_PED_VD_DEV_RESSARCIMENTO  R ON PED.CD_EMP = r.CD_EMP
					AND PED.CD_FILIAL = R.CD_FILIAL
					AND PED.CD_PED = R.CD_PED
			  LEFT JOIN V_PRC_FILIAL VF ON VF.CD_FILIAL = PED.CD_FILIAL
			   OUTER APPLY (SELECT ALIQ_ICMS as ALIQ_ICMS_INTERNO
							FROM EST_TRIB_ALIQ_ICMS
							WHERE UF_ORIG = UF_DEST
							AND UF_ORIG = VF.UF) TRIB
				LEFT JOIN EST_PROD_NCM_CADASTRO_COMB_POBREZA POBR ON EST_PROD.NR_NCM = POBR.NR_NCM COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS 
																	AND VF.UF = POBR.UF COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS
          WHERE PEND.FLAG_REALIZAR_FAT IN(1, 2) 
		    AND  R.TIPO > 0 
GO


